/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.ntutil;

import filenet.vw.ntutil.security.NTSecurity;
import filenet.vw.ntutil.security.base.NTSecurityToken;
import filenet.vw.ntutil.security.base.SSPIClient;
import filenet.vw.ntutil.security.base.SSPISecHandle;
import filenet.vw.ntutil.trace;
import java.applet.Applet;
import java.awt.Button;
import java.awt.TextField;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BoxLayout;

public class TestApplet
extends Applet
implements ActionListener {
    protected Button b1;
    public TextField statusTxt;

    public void init() {
        this.setLayout(new BoxLayout(this, 1));
        this.statusTxt = new TextField(80);
        this.add(this.statusTxt);
        this.b1 = new Button("Start Test");
        this.b1.addActionListener(this);
        this.add(this.b1);
    }

    public void destroy() {
        NTSecurity.release();
    }

    public void actionPerformed(ActionEvent ae) {
        try {
            String server = this.statusTxt.getText();
            NTSecurity test = new NTSecurity(server);
            NTSecurityToken tokenInfo = test.getCurrentThreadToken();
            if (tokenInfo != null) {
                trace.println("NTSecurity Initially, who amI? = " + tokenInfo.toString());
            } else {
                trace.println("NTSecurity Initially, no token ?");
            }
            for (int i = 0; i < 5; ++i) {
                trace.println("ITERATION " + Integer.toString(i));
                SSPIClient client = test.getSSPIClient();
                trace.println("NTSecurity, calling SSPIClient.authenticate!");
                if (client.authenticate()) {
                    trace.println("NTSecurity, getting serverCOntext");
                    SSPISecHandle svrContext = client.getServerContext();
                    NTSecurityToken testString = test.impersonateTest(svrContext);
                    if (testString != null) {
                        System.out.println("main: impersonateTest returns " + testString.toString());
                    } else {
                        trace.println("What!! main:impersonateTest failed?");
                    }
                }
                client.terminate();
            }
            tokenInfo = test.getCurrentThreadToken();
            if (tokenInfo != null) {
                trace.println("NTSecurity after client terminate, who amI? = " + tokenInfo.toString());
            } else {
                trace.println("NTSecurity after client terminate, no token ?");
            }
            test.release();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

